//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
template <typename T>
class C_TreeNode
{
    private :
//+----------------+
        T           info;
        C_TreeNode  *left,
                    *right;
//+----------------+
    public  :
//+----------------+
        C_TreeNode(T arg)
            :left(NULL),
            right(NULL),
            info(arg)
        {}
//+----------------+
        void SetLeft(C_TreeNode *ptr) { left = ptr; }
//+----------------+
        void SetRight(C_TreeNode *ptr) { right = ptr; }
//+----------------+
        T GetInfo(void) const { return info; }
//+----------------+
        C_TreeNode *GetLeft(void) const { return left; }
//+----------------+
        C_TreeNode *GetRight(void) const { return right; }
//+----------------+
};
//+------------------------------------------------------------------+
#define C_TreeNode C_TreeNode<T>
template <typename T>
class C_Tree
{
//+----------------+
    #define def_InfoToString(A) (A != NULL ? StringFormat("%d ", (*A).GetInfo()) : "")
    enum E_SEQ {eInOrder, ePreOrder, ePostOrder, eDestroy};
//+----------------+
    private :
        C_TreeNode *root;
        string      m_szInfo;
//+----------------+
        C_TreeNode *Insert(C_TreeNode *ptr, T info)
        {
            if (ptr == NULL)
                return new C_TreeNode(info);

            if (info < (*ptr).GetInfo()) (*ptr).SetLeft(Insert((*ptr).GetLeft(), info));
            else (*ptr).SetRight(Insert((*ptr).GetRight(), info));

            return ptr;
        }
//+----------------+
        void Extra(C_TreeNode *ptr, const E_SEQ type)
        {
            if (ptr == NULL) return;

            switch (type)
            {
                case eInOrder   :
                case ePostOrder :
                case eDestroy   :
                    Extra((*ptr).GetLeft(), type);
                    if (type == eInOrder) break;
                    Extra((*ptr).GetRight(), type);
            }
            m_szInfo += def_InfoToString(ptr);
            switch (type)
            {
                case ePreOrder  :
                    Extra((*ptr).GetLeft(), type);
                case eInOrder   :
                    Extra((*ptr).GetRight(), type);
                    break;
                case eDestroy   :
                    delete ptr;
            }
        }
//+----------------+
    public  :
//+----------------+
        C_Tree()
            :root(NULL)
        {}
//+----------------+
        ~C_Tree()
        {
            Extra(root, eDestroy);
        }
//+----------------+
        void Store(T info)
        {
            if (root == NULL) root = Insert(root, info);
            else Insert(root, info);
        }
//+----------------+
        string In_Order(void)
        {
            m_szInfo = "In Order: ";
            Extra(root, eInOrder);
            
            return m_szInfo;
        }
//+----------------+
        string Pre_Order(void)
        {
            m_szInfo = "Pre Order: ";
            Extra(root, ePreOrder);

            return m_szInfo;
        }
//+----------------+
        string Post_Order(void)
        {
            m_szInfo = "Post Order: ";
            Extra(root, ePostOrder);

            return m_szInfo;
        }
//+----------------+
    #undef def_InfoToString
//+----------------+
};
#undef C_TreeNode
//+------------------------------------------------------------------+
void OnStart(void)
{
    C_Tree <int> Tree;

    Tree.Store(10);
    Tree.Store(-6);
    Tree.Store(47);
    Tree.Store(35);
    Tree.Store(51);
    Tree.Store(90);
    Tree.Store(85);
    Tree.Store(40);

    Print(Tree.In_Order());
    Print(Tree.Pre_Order());
    Print(Tree.Post_Order());
}
//+------------------------------------------------------------------+